//
// Created by sachetto on 19/03/2021.
//

#ifndef MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H
#define MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H

#include <unistd.h>
#include "../common_types/common_types.h"
#include "../config/config_common.h"
#include <stdio.h>

#define SET_EXTRA_DATA_SIZE(value) *extra_data_size = (value)

struct extra_data_for_fibrosis {
    real INaFactor;
    real ICaLFactor;
    real Ko;
    real f;
    real hcmIn;
    real hcmOut;
	real INaKFactor;
    real INaCaFactor;
	real INaLFactor;

    real mCaL;
    real mNa;
    real mto;
    real mNaL;
    real mKr;
    real mKs;
    real mK1;
    real mNaCa;
    real mNaK;
    real mRel;
    real mUp;

    real modelID;
    
    real *fibrosis;
    
    real *sv0_ctrlNorm;
    real *sv0_ctrlIsch;
    real *sv0_hcmNorm;
    real *sv0_hcmIsch;

};

struct extra_data_for_fibrosis * set_common_schemia_data(struct config *config, uint32_t num_cells);

#endif // MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H
